#include <iostream>
#include <vector>
#include <set>
#include <map>
#include <string>
#include <algorithm>
using namespace std;
template <class T>
ostream& operator<<(ostream& cout, const vector<T>& vec)
{
	for (const T& t : vec)
		cout << t << " ";
	return cout << "\n";
}
template <class T1, class T2>
ostream& operator<<(ostream& cout, const pair<T1, T2>& p)
{
	return cout << p.first << " " << p.second << "\n";
}
#define For(i, n) for(int i = 0; i < n; ++i)
#define For3(i, s, n) for(int i = s; i < n; ++i)
#define For4(i, s, n, c) for(int i = s; i < n == c > 0; i += c)
#define all(i) i.begin(), i.end()
#define int long long
const int INF = 1e9 + 17;
const int MOD = 1e9 + 7;
const int N = 1e6 + 7;
const double alp = 0.00001;
bool betw(double& a, double& b, double& c)
{
	return min(b, c) - alp <= a && a <= max(b, c) + alp;
}
struct MVec
{
	double x = 0, y = 0;
	bool g = true;
	MVec()
	{

	}
	MVec(double x, double y) : x(x), y(y)
	{

	}
	MVec(int bd)
	{
		g = (bd != -1);
	}

	friend MVec operator+(const MVec& v1, const MVec& v2)
	{
		return MVec(v1.x + v2.x, v1.y + v2.y);
	}
	friend MVec& operator+=(MVec& v1, const MVec& v2)
	{
		v1.x += v2.x;
		v1.y += v2.y;
		return v1;
	}
	friend MVec operator-(const MVec& v1, const MVec& v2)
	{
		return MVec(v1.x - v2.x, v1.y - v2.y);
	}
	friend MVec& operator-=(MVec& v1, const MVec& v2)
	{
		v1.x -= v2.x;
		v1.y -= v2.y;
		return v1;
	}

	friend bool operator == (const MVec& v1, const MVec& v2)
	{
		return v1.x == v2.x && v1.y == v2.y;
	}

	friend MVec operator*(const MVec& v1, const MVec& v2)
	{

	}
};
bool betw(MVec& a, MVec& b, MVec& c)
{
	return betw(a.x, b.x, c.x) && betw(a.y, b.y, c.y);
}
struct Line
{
	MVec p1 = MVec(), p2 = MVec();
	double a, b, c;

	Line()
	{

	}

	Line(const MVec& v1, const MVec& v2) : p1(v1), p2(v2)
	{
		a = p1.y - p2.y;
		b = p2.x - p1.x;
		c = -(a * p1.x + b * p1.y);
	}
};
MVec intersect(Line l1, Line l2)
{
	double a1 = l1.a, a2 = l2.a, b1 = l1.b, b2 = l2.b, c1 = l1.c, c2 = l2.c;
	if (a1 * b2 == a2 * b1)
	{
		if (l1.p1 == l2.p1 || l1.p1 == l2.p2) return l1.p1;
		if (l1.p2 == l2.p1 || l1.p2 == l2.p2) return l1.p2;
		return MVec(-1);
	}

	double x = (c2 * b1 - c1 * b2) / (a1 * b2 - a2 * b1), y;
	
	if (b1 != 0)
		y = -(a1 * x + c1) / b1;
	else
		y = -(a2 * x + c2) / b2;

	MVec ans = MVec(x, y);

	if (betw(ans, l1.p1, l1.p2) && betw(ans, l2.p1, l2.p2))
		return ans;
	return MVec(-1);
}
#define DL(x, y) (((x) + (y) - 1) / (y))
vector<int> d;


int n;
vector<int> g[N];
vector<Line> lVec;
int tin[N];
int toP[N];
//int cntP[N];
int ct = 1;
int nP = 0;


int DFS(int v, int p)
{
	tin[v] = ct++;
	int sm = 0;
	for (int u : g[v])
	{
		if (u == p || tin[u] > tin[v]) continue;
		if (tin[u] != 0)
		{
			sm++;
		}
		else
		{
			sm += DFS(u, v);
		}
	}
	return sm;
}


void addReb(int u, int v)
{
	g[v].push_back(u);
	g[u].push_back(v);
}

void solve()
{
	cin >> n;
	For(i, n)
	{
		g[i].clear();
		tin[i] = 0;
		toP[i] = -1;
	}
	lVec.clear();
	ct = 1;
	nP = 0;

	int sm = 0;
	For(i, n)
	{
		int x1, y1, x2, y2;
		cin >> x1 >> y1 >> x2 >> y2;

		lVec.push_back(Line(MVec(x1, y1), MVec(x2, y2)));

		For(j, i)
		{
			MVec p = intersect(lVec[j], lVec[i]);
			if (p.g)
			{
				if (toP[i] != -1)
					addReb(toP[i], nP);
				else
					toP[i] = nP;
				if (toP[j] != -1)
					addReb(toP[j], nP);
				else
					toP[j] = nP;
				//if (cntP[i] >= 1)
				//{
				//	sm++;
				//}
				//if (cntP[j] >= 1)
				//{
				//	sm++;
				//}

				//cntP[i]++;
				//cntP[j]++;
				
				

				nP++;
			}
		}
	}

	//cout << sm - nP;
	cout << DFS(0, 0);
}
signed main()
{
	//////////
	{
	ios_base::sync_with_stdio(0);
	cin.tie(0);
	cout.tie(0);
	}
	//////////

	int t;
	cin >> t;
	while (t--)
	{
		solve();
		cout << "\n";
	}
}
